

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of LATCH is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_LOGIC := 'X';
   SIGNAL ENA_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (D_ipd, D, VitalExtendToFillDelay(tipd_D));
   VitalPropagateWireDelay (ENA_ipd, ENA, VitalExtendToFillDelay(tipd_ENA));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, ENA_ipd)

   -- timing check results
   VARIABLE Tviol_D_ENA	: X01 := '0';
   VARIABLE Tmkr_D_ENA	: TimeMarkerType;

   -- functionality results
   VARIABLE Violation : X01 := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: GlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalTimingCheck (D_ipd, "D", ENA_ipd, "ENA",
                           tsetup_D_ENA_posedge, tsetup_D_ENA_negedge,
                           thold_ENA_D_posedge, thold_ENA_D_negedge,
                           TRUE,
                           TO_X01(ENA_ipd) = '0',
                           InstancePath & "/LATCH",
                           Tmkr_D_ENA, Tviol_D_ENA);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_ENA;
      VitalStateTable(
        StateTable => LATCH_Q_tab,
        DataIn => (
               D_ipd, ENA_ipd),
        Result => Q_zd,
        PreviousDataIn => PrevData_Q);
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Q,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_ipd'last_event, VitalExtendToFillDelay(tpd_D_Q_posedge), TRUE),
                 1 => (ENA_ipd'last_event, VitalExtendToFillDelay(tpd_ENA_Q_posedge), TRUE)),
       GlitchData => Q_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;